import React from "react";

type num = {
    total: number, 
    page: number, 
    setPage: Function
}

export default function Pagination ({total, page, setPage} : num) {
    const numPages = Math.ceil(total / 15);

    return (
        <div>
            <button onClick={() => setPage(page - 1)} disabled={page === 1}>
                &lt;
            </button>

            {/* {Array(numPages)
                .fill(1)
                .map((_, i) => (
                    <button key={i + 1} onClick={() => setPage(i + 1)}>
                        {i + 1}
                    </button>
                ))} */}

            <button onClick={() => setPage(page + 1)} disabled={page === numPages}>
                &gt;
            </button>
        </div>
    );
};
