import { Types, ObjectId } from "mongoose";
import { Post, PostType } from "../models";
import { FileInfo, IFileInfo } from "../models";

//Create
export const createPostRow = async (post: PostType) => {
  const newPostRow = await Post.create({
    title: post.title,
    text: post.text,
    theme: post.theme,
    city: post.city,
    user: post.user,
    date: post.date,
    counts: 0,
    file: post.file,
  });
  return newPostRow;
};

export const createFilesRow = async (
  originalfilename?: string | null,
  newfilename?: string,
  picturepath?: string
) => {
  const newFileRow = await FileInfo.create({
    originalfilename: originalfilename,
    newfilename: newfilename,
    picturepath: picturepath,
  });
  // console.log("check", newFileRow);
  return newFileRow._id;
};

//Read
export const getPosts = async () => {
  const posts = await Post.find({}).sort({ date: -1 });
  return posts;
};

export const getFilesByPostId = async (postId: string) => {
  const files = await Post.findOne({ _id: postId }).populate("file");
  return files?.file;
};

//Update
export const addOneCount = async (_id: string, counts: number) => {
  const newCounts = await Post.findOneAndUpdate(
    { _id: _id },
    { counts: counts },
    { new: true }
  );
  return newCounts;
};

export const updatePostRow = async (post: PostType, postId: string) => {
  const newPost = await Post.findOneAndUpdate(
    { _id: postId },
    {
      title: post.title,
      text: post.text,
      theme: post.theme,
      city: post.city,
      date: post.date,
      user: post.user,
      file: post.file,
    },
    { new: true }
  );
  return newPost;
};

export const getOriginalFileName = async (_id: Types.ObjectId) => {
  const file = await FileInfo.findOne({ _id: _id });
  return file?.originalfilename;
};

export const updatedFileId = async (_id: string) => {
  const updatedFile = await Post.findOne({ _id: _id }).populate("file");
  return updatedFile?.file;
};

//Delete
export const deletePost = async (_id: string) => {
  const res = await Post.deleteOne({ _id: _id });
  return res;
};

export const deleteFile = async (_id: Types.ObjectId) => {
  const deleteOne = await FileInfo.deleteOne({ _id: _id });
  return deleteOne;
};

export const deleteFileByName = async (originalfilename: string) => {
  const deleteFile = await FileInfo.deleteOne({ originalfilename });
  return deleteFile;
};
