import { NextFunction, Request, Response } from "express";
import { asyncWrap } from "../helpers";
import jwt, { JwtPayload } from "jsonwebtoken";
import { jwtCofig, envConfig, cookieConfig } from "../config";
import { postDb } from "../db";



export const posting = asyncWrap(async (req, res) => {
    const { title, body, date, theme, city } = req.body;

    // 1) title 빈 문자열인지 확인 
    const titleString = postDb.checkTitleNull(title, );
    if (!titleString) {
        return res.status(422).send(`${title} 제목을 입력해 주세요`);
    }

    // 2) body 빈 문자열인지 확인
    const bodyString = postDb.checkBodyNull(body, );
    if (!bodyString) {
        return res.status(422).send(`${body} 여행 후기를 입력해 주세요`);
    }

    // 3) submit 이벤트 발생시 date값 입력
    const dateGet = postDb.getSubmitDate(date, );


    // 4) theme dropdown default-value일 경우 에러
    const themeSelect = postDb.selectTheme(theme, );
    if (!themeSelect) {
        return res.status(422).send(`${theme} 테마를 선택해 주세요`)
    }

    // 5) cuty dropdown default-value일 경우 에러
    const citySelect = postDb.selectCity(city, );
    if (!citySelect) {
        return res.status(422).send(`${city} 도시를 선택해 주세요`)
    }
    // 6) 토큰 생성
    const token = jwt.sign({  }, jwtCofig.secret, {
        expiresIn: jwtCofig.expires,
      });

    // 7) 쿠키에 토큰 저장
    res.cookie(cookieConfig.name, token, {
        maxAge: cookieConfig.maxAge,
        path: "/",
        httpOnly: envConfig.mode === "production",
        secure: envConfig.mode === "production",
      });

    // 8) 사용자 반환
    res.json({});
});