import React from "react";
import { Link, Outlet } from "react-router-dom";


export default function HomePage() {
    return (
      <div className="flex flex-col">
        <div className="flex flex-row h-12 place-content-between md:place-content-between xl:place-content-between ">
        <Link to="/"><div className="w-24 h-11 bg-blue-400 rounded">Travel Report</div></Link>
          <div className="flex flex-row-reverse">
            <Link to="/login"><div className="w-12 h-11 text-xs bg-yellow-400 rounded">Login</div></Link>
            <Link to="/board"><div className="w-12 h-11 text-xs bg-green-300 rounded">Board</div></Link>
          <div>
              <label>
                {/* <span className="sr-only">Search</span> */}
                <input className="placeholder:italic placeholder:text-slate-400 block bg-white w-full border border-slate-300 rounded-md py-2 pl-9 pr-3 shadow-sm focus:outline-none focus:border-sky-500 focus:ring-sky-500 focus:ring-1 sm:text-sm" placeholder="Search for anything..." type="text" name="search" />
              </label>
           </div>
          </div>
        </div>
        <hr />
        <Outlet />
      </div>
  
    );
  
  }