import React from "react";
import { BrowserRouter, Route, Routes, Link, Outlet} from "react-router-dom";
import "tailwindcss/tailwind.css";
import Header from "./pages/header";
import Body from "./pages/body";
import Board from "./pages/board";
import Login from "./pages/login";
import Citylist from "./pages/citylist";
import Theme from "./pages/theme";

export const App = () => {
  return (
    <BrowserRouter>
      <Routes>
        <Route path="/login" element={<Login />} />
        <Route path="/signup" element={<signup />} />
        <Route path="/" element={<Header />}>
          <Route index element={<Body />} />
          <Route path="/board" element={<Board />} />
        </Route>
      </Routes>
    </BrowserRouter>
  );
};
