import isLength from "validator/lib/isLength";
import { TypedRequestAuth } from "./auth.controller";
import { asyncWrap } from "../helpers";
import { mainimgDb } from "../db";

export const createMainimg = asyncWrap(async (reqExp, res, next) => {
  const req = reqExp as TypedRequestAuth<{ userId: string }>;

  const { theme, city, url, title} = req.body as {
    theme: string;
    city: string;
    url: string;
    title: string;
  };

  console.log("body", req.body);

    if (!isLength(url ?? "", { min: 1 })) {
      return res.status(422).send("이미지 url을 입력해주세요");
    }
 
  if (!isLength(title ?? "", { min: 1 })) {
    return res.status(422).send("이미지 제목을 입력해주세요");
  }

  const newMainimg = await mainimgDb.createMainimg({
    theme,
    city,
    url,
    title,
  });

  return res.json(newMainimg);
});

export const getMainimg = asyncWrap(async (req, res) => {
    const mainimgs = await mainimgDb.getMainimg();
    return res.json(mainimgs);
  });



  
