import { model, Schema, Types } from "mongoose";

export interface PostType {
  title: string;
  text: string;
  theme: string;
  city: string;
  user: Types.ObjectId | string;
  date: Date | number;
  counts?: number;
}

const PostSchema = new Schema<PostType>({
  title: {
    type: String,
    required: true,
  },
  text: {
    type: String,
    required: true,
  },
  theme: {
    type: String,
  },
  city: {
    type: String,
  },
  user: {
    type: Schema.Types.ObjectId,
    ref: "User",
  },
  date: {
    type: Date,
    default: Date.now(),
  },
  counts: {
    type: Number,
    default: 0,
  },
});

export default model<PostType>("Post", PostSchema);
