import React, { useReducer, useState } from "react";
import { Link, Outlet } from "react-router-dom";
import { useAuth } from "../auth/auth.context";

import "tailwindcss/tailwind.css";

export default function Header() {
  const { logout } = useAuth();
  return (
    <div className="flex flex-col ">
      <div className="flex py-10 ">
        <button className="shrink-0  mx-5">
          <Link to="/" className="hover:text-sky-300 focus:text-purple-500">
            Travel Report
          </Link>
        </button>

        <input
          className="md:ml-20 placeholder:text-white focus:outline-none focus:border-y-4 focus:border-l-4 focus:border-sky-500 md:placeholder:text-slate-400 w-20 md:w-1/2 border-y-4 border-l-4 border-sky-300 pl-9 rounded-l-full focus:border-0"
          placeholder="어디로 여행가고 싶나요?"
        />
        <button className="shrink-0 border-y-4  border-r-4 border-sky-500 rounded-r-full pr-4">
          검색
        </button>

        <div className="shrink-0 p-3 md:ml-40 h-12">
          {useAuth().user.isLoggedIn ? (
            <div className="flex">
              <Link to="/profile" className="mr-2 ">
                프로필
              </Link>
              <div className="border-0 border-r-2"></div>
              <div></div>
              <button
                className="ml-2 mr-2"
                onClick={() => {
                  logout();
                }}
              >
                로그아웃
              </button>
              <div className="border-0 border-r-2"></div>
              <div></div>
            </div>
          ) : (
            <button className="shrink-0 bg-white ">
              <Link
                className="hover:text-sky-300 focus:text-purple-500"
                to="/login"
              >
                로그인
              </Link>
            </button>
          )}
        </div>
        <button className="shrink-0 bg-white">
          <Link
            to="/board"
            className="hover:text-sky-300 focus:text-purple-500"
          >
            게시판
          </Link>
        </button>
      </div>

      <Outlet />
    </div>
  );
}
