import React from "react";
import { BrowserRouter, Route, Routes, Link, Outlet} from "react-router-dom";
import "tailwindcss/tailwind.css";
import Header from "./Pages/header";
import Body from "./Pages/body";
import Board from "./Pages/board";
import Login from "./Pages/login";
import Signup from "./Pages/signup";
import Posting from "./Pages/posting";

export const App = () => {
  return (
    <BrowserRouter>
      <Routes>
        <Route path="login" element={<Login />} />
        <Route path="signup" element={<Signup />} />
        
        <Route path="/" element={<Header />}>
          <Route index element={<Body />} />
          <Route path="board" element={<Board />} />
            <Route path="posting" element={<Posting/>} />
        </Route>
      </Routes>
    </BrowserRouter>
  );
};
