import React, { MouseEventHandler } from "react";

type CityProps = {
  handleClick: MouseEventHandler;
};

export default function Citylist({ handleClick }: CityProps) {
  return (
    <div className="overflow-auto w-full flex flex-row md:flex-col md:mr-24 bg-sky-100">
      <div className="text-center px-5 py-2 bg-sky-300 shrink-0">도시</div>
      <button
        id={"서울"}
        onClick={handleClick}
        className="px-5 py-2 hover:underline shrink-0"
      >
        서울
      </button>
      <button
        id={"부산"}
        onClick={handleClick}
        className="px-5 py-2 hover:underline shrink-0"
      >
        부산
      </button>
      <button
        id={"인천"}
        onClick={handleClick}
        className="px-5 py-2 hover:underline shrink-0"
      >
        인천
      </button>
      <button
        id={"대구"}
        onClick={handleClick}
        className="px-5 py-2 hover:underline shrink-0"
      >
        대구
      </button>
      <button
        id={"광주"}
        onClick={handleClick}
        className="px-5 py-2 hover:underline shrink-0"
      >
        광주
      </button>
      <button
        id={"대전"}
        onClick={handleClick}
        className="px-5 py-2 hover:underline shrink-0"
      >
        대전
      </button>
      <button
        id={"울산"}
        onClick={handleClick}
        className="px-5 py-2 hover:underline shrink-0"
      >
        울산
      </button>
      <button
        id={"세종"}
        onClick={handleClick}
        className="px-5 py-2 hover:underline shrink-0"
      >
        세종
      </button>
      <button
        id={"독도"}
        onClick={handleClick}
        className="px-5 py-2 hover:underline shrink-0"
      >
        독도
      </button>
      <button
        id={"제주"}
        onClick={handleClick}
        className="px-5 py-2 hover:underline shrink-0"
      >
        제주
      </button>
      {/* citylist */}
    </div>
    // Citylist Page
  );
}
