import React, { MouseEventHandler } from "react";

type ThemeProps = {
  handleClick: MouseEventHandler;
};

export default function Theme({ handleClick }: ThemeProps) {
  return (
    <div className="overflow-x-auto flex rounded md:justify-center">
      <button id={"서핑"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        서핑
      </button>
      <button id={"액티비티"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        액티비티
      </button>
      <button id={"캠핑"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300 ">
        캠핑
      </button>
      <button id={"스키"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        스키
      </button>
      <button id={"보트"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        보트
      </button>
      <button id={"사막"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        사막
      </button>
      <button id={"골프"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        골프
      </button>
      <button id={"동굴"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        동굴
      </button>
      <button id={"문화재"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        문화재
      </button>
      <button id={"동물원"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        동물원
      </button>
      <button id={"사이클링"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        사이클링
      </button>
    </div>
  );
}
