import React, { MouseEvent } from "react";
import { useLocation, useNavigate, Link, Outlet } from "react-router-dom";
import { postApi } from "../apis";
import { PostType } from "../types";

export interface PostState {
  state: PostType;
}

export function IntoPost() {
  const location = useLocation() as PostState;
  const post = location.state;
  const navigate = useNavigate();
  // console.log(post);

  const handleDeleteClick = async (event: MouseEvent<HTMLButtonElement>) => {
    const postId = event.currentTarget.id;
    const res = await postApi.deletePost(postId);
    navigate("/board", { replace: true });
    console.log("delete post", res);
  };

  return (
    <div>
      <div>
        <div>
          <div className="flex flex-row basis-8">
            <div className="border-2 border-current rounded">
              <button id={post._id} onClick={handleDeleteClick}>
                delete
              </button>
            </div>
            <div className="border-2 border-current rounded">
              <Link to="/edit" state={post}>
                <button>update</button>
              </Link>
            </div>
          </div>
          <div className="flex flex-row">
            <div className="flex basis-3/4 border-2 border-black rounded">
              제목: {post.title}
            </div>
            <div className="flex basis-1/4 border-2 border-black rounded">
              작성자: nickname
            </div>
          </div>
          <div className="flex flex-row">
            <div className="flex basis-1/4 border-2 border-black rounded">
              도시: {post.city}
            </div>
            <div className="flex basis-1/4 border-2 border-black rounded">
              테마: {post.theme}
            </div>
            <div className="flex basis-1/4 border-2 border-black rounded">
              작성일: {post.date}
            </div>
            <div className="flex basis-1/4 border-2 border-black rounded">
              조회수: {post.counts}
            </div>
          </div>
        </div>
        <div className="border-2 border-black rounded h-full">{post.text}</div>
      </div>
      {/* <Outlet /> */}
    </div>
  );
}
