import React from "react";
import {Link, Outlet} from "react-router-dom";

import "tailwindcss/tailwind.css";


export default function Header() {
    return (
      <div className="flex flex-col ">
        <div className="flex flex-row px-5 py-20 md:place-content-between">
          <button className="px-5 py-2">
            <Link to="/" className="hover:bg-gray-200 focus:text-purple-500 ">Travel Report</Link>
          </button>
          <div className="flex flex-row-reverse">
            <button className="px-5 py-2 bg-teal-400 rounded">
              <Link to="/login" className="hover:bg-teal-100 focus:text-purple-500 ">Login</Link>
            </button>
            <button className="px-5 py-2 bg-purple-400 rounded">
              <Link to="/board" className="hover:bg-purple-300 focus:text-purple-500 ">Board</Link>
            </button>
            <div>
              <label>
                {/* <span className="sr-only">Search</span> */}
                <span className="absolute inset-y-0 left-0 flex items-center pl-2">
                  <svg className="h-5 w-5 fill-slate-300" viewBox="0 0 20 20"></svg>
                </span>
                <input className="placeholder:italic placeholder:text-slate-400 block bg-white w-full border border-slate-300 rounded-md py-2 pl-9 pr-3 shadow-sm focus:outline-none focus:border-sky-500 focus:ring-sky-500 focus:ring-1 sm:text-sm" placeholder="Search for anything..." type="text" name="search" />
              </label>
            </div>
          </div>
        </div>
        <Outlet/>
      </div>
    );
  }