import { connect } from "mongoose";
import { mongoUri } from "../src/config";
import { Role, User } from "../src/models";
import { userDb } from "../src/db";

connect(mongoUri)
  .then(async (mongoose) => {
    const adminRole = await Role.findOne({ name: "admin" });
    if (!adminRole) {
      throw new Error("admin role이 없습니다. 먼저 role 테이블을 만드세요.");
    }
    await userDb.createUser({
      email: "admin@example.com",
      name: "admin",
      role: adminRole?._id,
      password: "asdfasdf",
    });
    console.log("admin 계정이 만들어졌습니다.");
    await mongoose.disconnect();
  })
  .catch((error) => console.log("롤 초기 생성 에러", error));
