import React from "react";

const slides = [
  "Slide 0",
  "Slide 1",
  "Slide 2",
  "Slide 3",
  "Slide 4",
  "Slide 5",
  "Slide 6",
  "Slide 7",
];

export const Slide = () => {
  const [page, setPage] = React.useState(1);
  const [style, setStyle] = React.useState("");
  const firstRightClick = React.useRef(true);
  const firstLeftClick = React.useRef(true);
  const slide = React.useRef(0);

  const handleLeftClick = () => {
    if (firstLeftClick.current) { //왼쪽 버튼이 true이면
      firstLeftClick.current = false;// 왼쪽 버튼은 false로 
      firstRightClick.current = true; // 오른쪽 버튼은 true로 
    } else {
      setPage(page - 1); // 왼쪽 버튼이 false이면 눌렸을때 page-1
    }
    slide.current -= 1;
    setStyle("-translate-x-full animate-slidetoright");
  };

  const handleRightClick = () => {
    if (firstRightClick.current) {
      firstLeftClick.current = true;
      firstRightClick.current = false;
    } else {
      setPage(page + 1);
    }
    slide.current += 1;
    setStyle("animate-slidetoleft");
  };

  console.log(`page: ${page}`);
  console.log(`style: ${style}`);
  console.log(slides.slice(page - 1, page + 2));
  console.log(`slide number: ${slide.current}`);

  return (
    <div className="flex flex-col items-center text-center">
      <h1>슬라이드</h1>
      <div className="h-screen w-full">
        <div
          key={Math.random()}
          className="flex overflow-x-hidden border-solid border-2 w-full h-1/2 text-8xl"
        >
          {slides.slice(page - 1, page + 2).map((slide) => (
            <div
              key={slide}
              className={`basis-full grow-0 shrink-0 border-8 bg-orange-300 ${style}`}
            >
              {slide}
            </div>
          ))}
        </div>
        <div>
          <button
            onClick={handleLeftClick}
            disabled={slide.current < 1}
            className="bg-gray-400 p-1 disabled:opacity-40"
          >
            &lt;
          </button>
          <button
            onClick={handleRightClick}
            disabled={slide.current > slides.length - 2}
            className="bg-gray-400 p-1 disabled:opacity-40"
          >
            &gt;
          </button>
        </div>
      </div>
    </div>
  );
};
