import React, { useEffect, useState } from "react";
import { handleProfile } from "./auth.helper";

export default function Profile() {
  // 로컬 저장소에는 로그인 여부만 저장
  const [email, setemail] = useState("");

  const emailChange = async () => {
    const profile = await handleProfile();

    setemail(profile.email);
  };

  useEffect(() => {
    emailChange();
  }, []);

  return (
    <div className="grid ">
      <div className="ml-20 mt-10">프로필 </div>
      <div className="grid m-20 border-0 border-y-2">
        <div className="flex">
          <div className="py-10 basis-1/5 border-0 border-r-2 bg-gray-100 grid place-items-center ">
            Email
          </div>
          <div className="basis-full">{email}</div>
        </div>
        <div className="flex border-0 border-t-2">
          <div className="py-10 basis-1/5 border-0 border-r-2 bg-gray-100 grid place-items-center">
            사진
          </div>
          <div className="basis-full">a</div>
        </div>
        <div className="flex border-0 border-t-2">
          <div className="py-10 basis-1/5 border-0 border-r-2 bg-gray-100 grid place-items-center">
            별명
          </div>
          <div className="basis-full">a</div>
        </div>
      </div>
    </div>
  );
}
