import { Posting, PostingType } from "../models";
import { Post, PostType } from "../models";

export const createPosting = async (posting: PostingType) => {
  const newPosting = await Posting.create({
    title: posting.title,
    text: posting.text,
    theme: posting.theme,
    city: posting.city,
    username: posting.username,
  });
  return newPosting;
};

export const createPost = async (post: PostType) => {
  const newPost = await Post.create({
    title: post.title,
    theme: post.theme,
    city: post.city,
    date: post.date,
    counts: post.counts,
  });
};
