import React from "react";
import { BrowserRouter, Route, Routes, Link, Outlet } from "react-router-dom";
import "tailwindcss/tailwind.css";
import { Login, Signup } from "./auth";
import { Board } from "./board";
import { Header, Body } from "./home";
import Posting from "./post/posting";
import Layout from "./commons/layout";

export const App = () => {
  return (
    <BrowserRouter>
      <Routes>
        <Route element={<Layout />}>
          <Route path="login" element={<Login />} />
          <Route path="signup" element={<Signup />} />
          <Route path="/" element={<Header />}>
            <Route index element={<Body />} />
            <Route path="board" element={<Board />} />
            <Route path="posting" element={<Posting />} />
          </Route>
        </Route>
      </Routes>
    </BrowserRouter>
  );
};
