import React, { MouseEventHandler } from "react";

type CityProps = {
  handleClick: MouseEventHandler;
};

export default function Citylist({ handleClick }: CityProps) {
  return (
    <div className="overflow-auto w-full  flex flex-row md:flex-col md:mr-24 bg-sky-100">
      <div className="text-start px-5 py-2 bg-white whitespace-nowrap">
        도시
      </div>
      <button
        id={"Seoul"}
        onClick={handleClick}
        className="text-start  px-5 py-2 hover:underline whitespace-nowrap"
      >
        서울
      </button>
      <button
        id={"Busan"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline whitespace-nowrap"
      >
        부산
      </button>
      <button
        id={"Incheon"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline whitespace-nowrap"
      >
        인천
      </button>
      <button
        id={"Daegoo"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline whitespace-nowrap"
      >
        대구
      </button>
      <button
        id={"Gwangjoo"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline whitespace-nowrap"
      >
        광주
      </button>
      <button
        id={"Daejeon"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline whitespace-nowrap"
      >
        대전
      </button>
      <button
        id={"Woolsan"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline whitespace-nowrap"
      >
        울산
      </button>
      <button
        id={"Sejong"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline whitespace-nowrap"
      >
        세종
      </button>
      <button
        id={"Dokdo"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline whitespace-nowrap"
      >
        독도
      </button>
      <button
        id={"Jeju"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline whitespace-nowrap"
      >
        제주
      </button>
      {/* citylist */}
    </div>
    // Citylist Page
  );
}
