import React, { useEffect, MouseEvent } from "react";
import { Outlet, useSearchParams } from "react-router-dom";
import Theme from "./theme";
import Citylist from "./citylist";
import getpic from "./pic";

const initSearchParams = { "theme": "", "city": "" }

export default function Body() {

    const [searchParams, setSearchParams] = useSearchParams(initSearchParams)
    let getpics = getpic();

    useEffect(() => {
        console.log(searchParams.get('theme'), searchParams.get('city'))
        // setSearchParams(searchParams)
    }, [])

    const themeHandleClick = (event: MouseEvent<HTMLButtonElement>) => {
        console.log(`theme id= ${event.currentTarget.id}`)
        setSearchParams({
            ...Object.fromEntries(searchParams),
            theme: event.currentTarget.id,
        })
    }

    const cityHandleClick = (event: MouseEvent<HTMLButtonElement>) => {
        console.log(`city id= ${event.currentTarget.id}`)
        setSearchParams({
            ...Object.fromEntries(searchParams),
            city: event.currentTarget.id
        })
    }

    const Idpics = getpics.filter(p =>
            p.themeid == searchParams.get('theme')&&            
            p.cityid == searchParams.get('city')   
        )
    
        return (
            <div className="flex flex-col px-1 py-1">
                <Theme handleClick={themeHandleClick} />
                <div className="flex flex-col md:flex-row py-10 ">
                    <Citylist handleClick={cityHandleClick} />
                    <div className="overflow-y-auto flex mr:10 md:basis-4/5 grid grid-rows-3 grid-cols-5">
                        {Idpics.map((pic, index:number) => (
                        <div className="m-1 shrink-0 bg-gray-200 rounded overflow-hidden shadow-md" key={index}>
                            <img src={pic.url} className="w-full h-10 md:h-20 object-cover"/>
                            <p className="text-center text-xs">{pic.name}</p>
                        </div>
                     ))}
                    </div>
                </div>
                <Outlet />
            </div>
            // Body Page
        );
    };
