import { model, Schema, Types } from "mongoose";

export interface MainimgType {
  theme: string;
  city: string;
  title: string;
  fileInfo?: Types.ObjectId;
}

const MainimgSchema = new Schema<MainimgType>({
  theme: {
    type: String,
  },
  city: {
    type: String,
  },
  title: {
    type: String,
    required: true,
  },
  fileInfo: { type: Schema.Types.ObjectId, ref: "Fileinfo" },
});

export default model<MainimgType>("Mainimg", MainimgSchema);
