import { Post, PostType } from "../models";
import { FileInfo, IFileInfo } from "../models";

export const createPostRow = async (post: PostType) => {
  const newPostRow = await Post.create({
    title: post.title,
    text: post.text,
    theme: post.theme,
    city: post.city,
    user: post.user,
    date: post.date,
    counts: 0,
  });
  console.log("check", newPostRow);
  return newPostRow;
};

export const createFilesRow = async (
  originalfilename?: string | null,
  newfilename?: string,
  picturepath?: string
) => {
  const newFileRow = await FileInfo.create({
    originalfilename: originalfilename,
    newfilename: newfilename,
    picturepath: picturepath,
  });
  return newFileRow;
};

export const findFileByPostInfo = async (title: string, usreId: string) => {
  const posts = await Post.find({ title: title, userId: usreId });
  return posts;
};

export const getPosts = async () => {
  const posts = await Post.find({});
  return posts;
};

export const addOneCount = async (_id: string, counts: number) => {
  const newCounts = await Post.findOneAndUpdate(
    { _id: _id },
    { counts: counts },
    { new: true }
  );
  // console.log(newCounts);

  return newCounts;
};

export const getPost = async (_id: string) => {
  const post = await Post.findOne({ _id: _id });
  return post;
};

export const deletePost = async (_id: string) => {
  const res = await Post.deleteOne({ _id: _id });
  return res;
};

export const updateOnePost = async (post: PostType, _id: string) => {
  const newPost = await Post.findOneAndUpdate(
    { _id: _id },
    {
      title: post.title,
      text: post.text,
      theme: post.theme,
      city: post.city,
      date: post.date,
      counts: post.counts,
      user: post.user,
    },
    { new: true }
  );
  return newPost;
};
