import React, { FormEvent, useEffect, useState } from "react";
import { useNavigate } from "react-router-dom";
import isLength from "validator/lib/isLength";
import equals from "validator/lib/equals";
import { catchErrors } from "../helpers";
import { PostType } from "../types";
import { postApi } from "../apis";
import { File } from "formidable";

export default function Posting() {
  const [city, setCity] = useState<string>("city");
  const [theme, setTheme] = useState<string>("theme");
  const [title, setTitle] = useState<string>("");
  const [text, setText] = useState<string>("");
  const [file, setFile] = useState<FileList>();
  const [imgSrc, setImgSrc] = useState<string[]>();
  const navigate = useNavigate();

  const [user, setUser] = useState<PostType>({
    title: "",
    text: "",
    theme: "",
    city: "",
    date: "",
    user: "",
    counts: 0,
    _id: "",
  });

  const [loading, setLoading] = useState(false);
  const [error, setError] = useState("");
  const [disabled, setDisabled] = useState(false);
  const [success, setSuccess] = useState(false);

  const imgArr = new Array();

  const sendImg2Db = async (filelist: FileList) => {
    const formdata = new FormData();
    formdata.append("title", user.title);
    formdata.append("text", user.text);
    formdata.append("theme", user.theme);
    formdata.append("city", user.city);
    if (!(filelist === undefined || filelist === null)) {
      for (var i = 0; i < filelist.length; i++) {
        formdata.append("picture", filelist?.[i]);
      }
      // formdata: post, imgs
      const res = await postApi.createImgAndPost(formdata);
    }
    // else {
    //   const res = await postApi.createImgAndPostTable(formdata);
    // }
  };

  async function handlePostSubmit(event: FormEvent) {
    event.preventDefault();
    try {
      setError("");
      console.log("user data", user);
      if (postingFormMatch(user)) {
        setLoading(true);
        if (file) {
          sendImg2Db(file);
        }
        // const res = await postApi.posting(user);
        // console.log("서버연결됬나요", res);

        navigate("/board", { replace: true });
        setSuccess(true);
        setError("");
      }
    } catch (error) {
      console.log("에러발생");
      catchErrors(error, setError);
    } finally {
      setLoading(false);
    }
  }

  function postingFormMatch(user: PostType) {
    if (!isLength(user.title ?? "", { min: 1 })) {
      setError("제목을 입력해 주세요.");
      return false;
    } else if (!isLength(user.text ?? "", { min: 1 })) {
      setError("내용을 입력해 주세요.");
      return false;
    } else if (equals(city, "city")) {
      setError("도시를 선택해 주세요.");
      return false;
    } else if (equals(theme, "theme")) {
      setError("테마를 선택해 주세요.");
      return false;
    } else {
      return true;
    }
  }

  const titleChange = (event: React.ChangeEvent<HTMLTextAreaElement>) => {
    const title = event.currentTarget.value;
    const newUser = { ...user, title: title };
    console.log(event.currentTarget.value);
    setTitle(event.currentTarget.value);
    setUser(newUser);
  };

  const textChange = (event: React.ChangeEvent<HTMLTextAreaElement>) => {
    const text = event.currentTarget.value;
    const newUser = { ...user, text: text };
    console.log(event.currentTarget.value);
    setText(event.currentTarget.value);
    setUser(newUser);
  };

  const cityChange = (event: React.ChangeEvent<HTMLSelectElement>) => {
    const city = event.currentTarget.value;
    const newUser = { ...user, city: city };
    console.log(event.currentTarget.value);
    setCity(event.currentTarget.value);
    setUser(newUser);
  };

  const themeChange = (event: React.ChangeEvent<HTMLSelectElement>) => {
    const theme = event.currentTarget.value;
    const newUser = { ...user, theme: theme };
    console.log(event.currentTarget.value);
    setTheme(event.currentTarget.value);
    setUser(newUser);
  };

  const handleInputPic = async (event: React.ChangeEvent<HTMLInputElement>) => {
    const maxImg = 10;
    const { files } = event.target;

    if (!(files === null)) {
      setFile(files);
    }

    if (!(files?.length === undefined)) {
      if (files?.length <= maxImg) {
        for (var i = 0; i < files.length; i++) {
          const reader = new FileReader();
          reader.readAsDataURL(files?.[i]);

          reader.onload = (e) => {
            imgArr.push(e.target?.result);
            setImgSrc(imgArr);
          };
        }
      } else {
        alert(`사진은 최대 ${maxImg}장까지 업로드 가능합니다!`);
      }
    }
  };

  return (
    <div className="flex flex-col border-3 ">
      <form onSubmit={handlePostSubmit} className="w-full items-center">
        <div className="flex flex-row relative">
          <p className="basis-1/12 gap-x-8">Id</p>
          <p className="basis-6/12 invisible">empty</p>
          <div className="basis-2/12 border-2 border-sky-300">
            <input type="file" multiple onChange={handleInputPic} />
          </div>
          <select
            name="city"
            id="Questions"
            className="border-2 border-sky-300 w-1/12"
            onChange={cityChange}
            defaultValue="질문종류"
          >
            <option value="질문종류">도시</option>
            <option value="Seoul">서울</option>
            <option value="Busan">부산</option>
            <option value="Incheon">인천</option>
            <option value="Daegoo">대구</option>
            <option value="Kwangjoo">광주</option>
            <option value="Daejeon">대전</option>
            <option value="Woolsan">울산</option>
            <option value="Sejong">세종</option>
            <option value="Dokdo">독도</option>
            <option value="Jeju">제주</option>
          </select>
          <select
            name="theme"
            id="Questions"
            className="border-2 border-sky-300 w-1/12"
            onChange={themeChange}
            defaultValue="질문종류"
          >
            <option value="질문종류">테마</option>
            <option value="cycling">사이클링</option>
            <option value="surfing">서핑</option>
            <option value="activity">액티비티</option>
            <option value="camping">캠핑</option>
            <option value="sking">스키</option>
            <option value="boat">보트</option>
            <option value="desert">사막</option>
            <option value="golf">골프</option>
            <option value="cave">동굴</option>
            <option value="history">문화재</option>
            <option value="zoo">동물원</option>
            <option value="cycling">사이클링</option>
          </select>

          <button
            type="submit"
            className="border-2 border-sky-300 basis-1/12 gap-x-8"
          >
            글쓰기
          </button>
        </div>

        <div className="flex">
          <textarea
            name="title"
            onChange={titleChange}
            placeholder="title"
            className="w-full h-8 border-2 border-sky-300"
          ></textarea>
        </div>
        <div className="flex flex-col">
          <div className="flex h-48 overflow-x-scroll">
            {imgSrc?.map((img, i) => (
              <img key={i} src={img} width={200} height={200} />
            ))}
          </div>
          <textarea
            onChange={textChange}
            name="text"
            placeholder="text"
            className="w-full h-96 border-2 border-sky-300"
          ></textarea>
        </div>
      </form>
    </div>
  );
}
