import React, { useRef, useState } from "react";

type num = {
    slides: any[],
}

export function MySlide({ slides}: num) {

    const firstLeftClick = useRef(true);
    const firstRightClick = useRef(true);
    const [page, setPage] = useState(1);
    const [slide,setSlide] = useState(1);
    // const slide = useRef(1);
    const [style, setStyle] = useState("");

    const leftClick = () => {
        if (firstLeftClick.current) {
            firstLeftClick.current = false;
            firstRightClick.current = true;
        } else {
            setPage(page - 1)
        }
        // slide.current -= 1;
        setSlide(slide-1)
        setStyle("-translate-x-full animate-slidetoright");
    };

    const rightClick = () => {
        if (firstRightClick.current) {
            firstLeftClick.current = true;
            firstRightClick.current = false;
        } else {
            setPage(page + 1)
        }
        // slide.current += 1;
        setSlide(slide+1)
        setStyle("animate-slidetoleft");
    };

    return (
        <div className="flex flex-row justify-center items-center ">
            <button className="mx-3 w-6 h-6 rounded-full hover:bg-sky-100 hover:text-gray-400"onClick={leftClick} disabled={slide === 1}>
                &lt;
            </button>
            <div
                className={`m-3 md:m-5 md:basis-4/5 flex flex-row relative w-full overflow-hidden`}
            >
                {slides.slice(page - 1, page + 2).map((slide) => (
                    <div key={Math.random()} className="min-w-full"
                    >
                        <div key={slide} className={`inline-grid grid-cols-2 ${style} min-w-full`}>
                            {slide}
                        </div>
                    </div>
                ))}
            </div>
            <button className="mx-3 w-6 h-6 rounded-full hover:bg-sky-100 hover:text-gray-400"onClick={rightClick} disabled={slide === slides.length}>
                &gt;
            </button>
        </div>


    );
};
