import React, { MouseEventHandler } from "react";
import { Link } from "react-router-dom";
import { PostType } from "../types";
import { IntoPost } from "./intopost";

export type Props = {
  post: PostType;
  handleClick: MouseEventHandler;
};

export default function Post({ handleClick, post }: Props) {
  return (
    <div className="flex flex-row h-16 divide-x-2 border-2 border-solid">
      <div className="basis-full truncate">
        <button id={post._id} onClick={handleClick}>
          <Link to={`/post/${post._id}`} state={post}>
            {post.title}
          </Link>
        </button>
      </div>
      <div className="basis-3/12 text-xs md:text-lg">
        {post.date.slice(0, 10)}
      </div>
      <div className="basis-3/12">{post.counts}</div>
    </div>
  );
}
