import { userDb } from "../db";
import { asyncWrap } from "../helpers/asyncWrap";
import { Request } from "express";
import { TypedRequest } from "../types";

export interface TypedRequestAuth<T> extends Request {
  auth: T;
}

export const getUsers = asyncWrap(async (req, res) => {
  const users = await userDb.getUsers();
  return res.json(users);
});

export const createUser = asyncWrap(async (req, res) => {
  const user = req.body;
  console.log("user body", user);
  const newUser = await userDb.createUser(user);
  return res.json(newUser);
});

export const getProfile = asyncWrap(async (reqExp, res) => {
  const req = reqExp as TypedRequestAuth<{ userId: string }>; // 앞에서는 토큰으로써 사용하기 때문에 JwtPayload 를 사용하고 여기서는 verify 에서 토큰을 디코딩했기에 ObjectId 타입의 string으로 바뀌게 된다.

  const { userId } = req.auth;
  const profile = await userDb.getProfile(userId);
  res.json(profile);
});

export const postPicture = asyncWrap(async (reqExp, res) => {
  const req = reqExp as TypedRequest;
  const { userId } = req.auth;
  const field = req.body;
  const file = req.files;

  if (!Array.isArray(file.picture)) {
    //파일 좁히기 중
    if (!Array.isArray(field.nickname)) {
      const nickname = field.nickname;
      if (!(file.picture === undefined)) {
        const originalfilename = file.picture.originalFilename;
        const newfilename = file.picture.newFilename;
        const picturepath = file.picture.filepath;
        userDb.postPicture(
          userId,
          nickname,
          originalfilename,
          newfilename,
          picturepath
        );
      } else {
        userDb.postPicture(userId, nickname);
      }
    }
  }

  res.json();
});

export const deleteUser = asyncWrap(async (reqExp, res) => {
  const req = reqExp as TypedRequestAuth<{ userId: string }>; // 앞에서는 토큰으로써 사용하기 때문에 JwtPayload 를 사용하고 여기서는 verify 에서 토큰을 디코딩했기에 ObjectId 타입의 string으로 바뀌게 된다.

  const { userId } = req.auth;
  const finish = await userDb.deleteUser(userId);
  if (finish?.deletedCount === 1) {
    res.json(true);
  } else {
    res.status(422).send("삭제에 실패하였습니다.");
  }
});
