import React, { MouseEvent, useEffect, useState } from "react";
import { useLocation, useNavigate, Link, Outlet } from "react-router-dom";
import { catchErrors } from "../helpers";
import { postApi } from "../apis";
import { PostType } from "../types";

export interface PostState {
  state: PostType;
}

export interface FileType {
  id: string;
  post: string;
  originalfilename: string;
  newfilename: string;
  picturepath: string;
}

export interface FilesList {
  filesList: FileType[];
}

export function IntoPost() {
  const location = useLocation() as PostState;
  const post = location.state;
  const navigate = useNavigate();
  const [filesList, setFilesList] = useState<FileType[]>();
  // console.log(post);

  const [loading, setLoading] = useState(false);
  const [error, setError] = useState("");
  const [addSuccess, setAddSuccess] = useState(false);
  const [delSuccess, setDelSuccess] = useState(false);

  useEffect(() => {
    getFilesList(post._id);
    console.log("newfilename", filesList?.[0].newfilename);
  }, []);

  const getFilesList = async (postId: string) => {
    const res = await postApi.getFileByPostId(postId);
    setFilesList(res);
  };

  const handleDeleteClick = async (event: MouseEvent<HTMLButtonElement>) => {
    try {
      if (confirm("삭제하시겠습니까?") == true) {
        const postId = event.currentTarget.id;
        const res = await postApi.deletePost(postId);
        navigate("/board", { replace: true });
        console.log("delete post", res);
      } else {
        return false;
      }
    } catch (error) {
      console.log("에러발생");
      catchErrors(error, setError);
    }
  };

  return (
    <div>
      <div>
        <div>
          <div className="flex flex-row h-8 gap-x-1 place-content-end">
            <div className="w-8">
              <button
                id={post._id}
                onClick={handleDeleteClick}
                className="border-2 border-sky-100 rounded-full h-8 w-8 text-xs text-center transition delay-150 bg-white-400 hover:-translate-y-1 hover:scale-110 hover:bg-red-300 duration-300"
              >
                삭제
              </button>
            </div>
            <div className="w-8">
              <Link to="/edit" state={post}>
                <button className="border-2 border-sky-100 rounded-full h-8 w-8 text-xs transition delay-150 bg-white-400 hover:-translate-y-1 hover:scale-110 hover:bg-sky-300 duration-300">
                  수정
                </button>
              </Link>
            </div>
          </div>
          <div className="flex flex-col h-16 md:h-8 md:flex-row">
            <div className="flex basis-1/2 place-content-between h-8">
              <div className="flex basis-1/2 border-2 border-sky-200 rounded h-8">
                작성자: {post.user.slice(0, 8)}
              </div>
              <div className="flex basis-1/2 border-2 border-sky-200 rounded h-8">
                작성일: {post.date.slice(0, 10)}
              </div>
            </div>
            <div className="flex basis-1/2 place-content-between h-8">
              <div className="flex basis-1/3 border-2 border-sky-300 rounded">
                도시: {post.city}
              </div>
              <div className="flex basis-1/3 border-2 border-sky-300 rounded">
                테마: {post.theme}
              </div>
              <div className="flex basis-1/3 border-2 border-sky-300 rounded">
                조회수: {post.counts}
              </div>
            </div>
          </div>
          <div className="flex flex-row h-8 gap-x-1 ">
            <div className="flex w-full border-2 border-sky-200 rounded">
              제목: {post.title}
            </div>
          </div>
        </div>
        <div className="flex-row border-2 border-sky-400 rounded h-48 gap-x-2 ">
          <div className="flex gap-x-2 h-48 overflow-x-scroll">
            {filesList?.map((file, i) => (
              <img
                key={i}
                src={"http://localhost:3000/images/" + file.newfilename}
                width={200}
                height={200}
              />
            ))}
          </div>
        </div>
        <div className="border-2 border-sky-500 rounded h-96">{post.text}</div>
      </div>
    </div>
  );
}
