import { Link, Outlet } from "react-router-dom";
import React from "react";

export default function Layout(){
    return (
      
      <div className="flex flex-col">
        
        <div className="flex flex-row px-5 py-20 place-content-between">
        
          <div className="px-5 py-2 bg-amber-400 rounded">
            
            <Link to="/">Travel Report</Link>
            
          </div>
          <div className="flex flex-row-reverse">
          
            <div className="px-5 py-2 bg-teal-400 rounded">
             
              <Link to="/login">Login</Link>
              
            </div>
            <div className="px-5 py-2 bg-purple-400 rounded">
              <Link to="/board">Board</Link>
              
            </div>
            
            <div>
              <label>
                {/* <span className="sr-only">Search</span> */}
                <span className="absolute inset-y-0 left-0 flex items-center pl-2">
                  <svg className="h-5 w-5 fill-slate-300" viewBox="0 0 20 20"></svg>
                </span>
                <input className="placeholder:italic placeholder:text-slate-400 block bg-white w-full border border-slate-300 
                rounded-md py-2 pl-9 pr-3 shadow-sm focus:outline-none focus:border-sky-500
                 focus:ring-sky-500 focus:ring-1 sm:text-sm" placeholder="Search for anything..." type="text" name="search" />
              </label>
            </div>
          </div>
          
        </div>
        
          <div className="flex px-5 py-5">
            <div className="flex w-full bg-emerald-400 rounded"> <Link to="/theme">Theme</Link> </div>
            
          </div>
          <div className="flex flex-row px-5 py-40 place-content-between">
            <div className="px-20 py-40 bg-gray-400 rounded"> <Link to="/list">List</Link> </div>
            
            <div className="w-60 px-80 py-60 mr-16 bg-red-400 rounded"> pic<Outlet /> </div>
          </div>
        
      </div>
      
    );
  }