import React from "react";
import { Route, Routes, BrowserRouter} from "react-router-dom";
import "tailwindcss/tailwind.css";

import  Layout  from "./Layout";
import  Home  from "./Home";
import  Theme  from "./Theme";
import  List  from "./list";
import  Board  from "./Board";
import  Login  from "./Login";
import  Signup  from "./Signup";
import  Forgot  from "./Forgot";

export const App = () => {
  return (
    <BrowserRouter>
      <Routes>
        <Route>
          <Route path="/" element={<Layout />}>
            <Route index element={<Home />} />
            <Route path="board" element={<Board />} />
            <Route path="theme" element={<Theme />} />
            <Route path="list" element={<List />} />
          </Route>
        </Route>
        <Route path="login" element={<Login />} >
          <Route path="/" element={<Home />} />
          <Route path="signup" element={<Signup />} />
          <Route path="forgot" element={<Forgot />} />
        </Route>
      </Routes>
    </BrowserRouter>
  );
};

