import React, { useState } from "react";
import { Link } from "react-router-dom";


function PasswordUpdate() {
  const [password, setPassword] = useState("");
  const [confirm, setConfirm] = useState("");
  const [result, setResult] = useState("");
  const [email, setEmail] = useState("");
  const [alert, setAlert] = useState("");

  function isEmail() {
    var regExp = /^[0-9a-zA-Z]([-_\.]?[0-9a-zA-Z])*@[0-9a-zA-Z]([-_\.]?[0-9a-zA-Z])*\.[a-zA-Z]{2,3}$/i;
    
      if(regExp.test(email)){
        setAlert("이메일 형식이 맞습니다.")
      }else{
        setAlert("이메일 형식이 틀립니다.")
      }
     return
  }

  const reform = () => {

    if (password && confirm){
    
      if (password==confirm) {
        setResult("비밀번호가 일치합니다.");
      } else {
        setResult("비밀번호가 다릅니다.");
      }
    }else {
      setResult("비밀번호가 입력되지 않았습니다.")
    }

  };

  return (
    <div>
      <div className="place-self-center py-3 border-b border-white ">
        <input
          className="placeholder:text-slate-300
          bg-white border border-slate-500 rounded-2xl
          py-2 pl-9 pr-3 
          focus:border-black"placeholder="비밀번호" type="text"
          name="password"
          value={password}
          onChange={(e) => setPassword(e.target.value )}
        />
      </div>
      <div className="place-self-center py-3 border-b border-white ">
        
        <input
          className="placeholder:text-slate-300
          bg-white border border-slate-500 rounded-2xl
          py-2 pl-9 pr-3 
          focus:border-black"placeholder="비밀번호 확인" type="text"
          name="confirm"
          value={confirm}
          onKeyUp={reform} onChange={(e) => setConfirm(e.target.value )}
          >
          
        </input>
      </div>
      <p>{result}</p>

      <input className="placeholder:text-slate-300
            bg-white border border-slate-500 rounded-2xl
            py-2 pl-9 pr-3 
            focus:border-black
            " placeholder="email" type="text" name="Id" 
      onChange={(e) => setEmail(e.target.value )}
      onKeyUp={isEmail}
      />
      <p>{alert}</p>
    </div>
  );
}



export default function Signup () {
  return(

  <div className="gap-5 flex flex-col ">
    <div className="p-12 w-1/2 h-1/2 md:w-40 md:h-1/6 bg-red-400 place-self-center rounded-2xl">
          <Link to="/">Travel Report</Link>
        </div>
      <div className="flex flex-col w-auto h-80 md:w-1/2 bg-white border-2 border-black grid place-items-center rounded-xl place-self-center">
        
          
        <div className="place-self-center py-3 border-b border-white ">
          <input className="placeholder:text-slate-300
            bg-white border border-slate-500 rounded-2xl
            py-2 pl-9 pr-3 
            focus:border-black" placeholder="ID " type="text"/>
        </div>
          
        <div className="showText place-self-center">
          <PasswordUpdate />
        </div>
        
        <button className="place-self-center py-3 border-b border-white 
            ">
              회원가입 버튼
        </button>
            
      </div> 
    
    
  </div>
  )
}
//출처 : //https://www.daleseo.com/react-forms/