import React, { useState, MouseEvent } from "react";
import { PostType } from "./typesrc";

type Props = {
    post: PostType;
}

export default function Post({ post }: Props) {
    const [count, setCount] = useState(0);

    // const titleHandleClick = (event:MouseEvent<HTMLButtonElement>) => {
    //     setCount(count + 1)
    // }

    return (
        <div className="flex flex-row h-16 divide-x-2 border-2 border-solid">
            <div className="basis-full">
                <button id={post.id} onClick={() => setCount(count + 1)}>{post.title}</button>
            </div> {/*<Link to>title</Link> */}
            <div className="basis-3/12">{post.date}</div>
            <div className="basis-2/12">{count}</div>
        </div>
    );
}