import React, { useRef, useState } from "react";

type num = {
    total: number,
    page: number,
    setPage: Function,
    style: string,
    setStyle: Function,
    // slides : any[],
}

export function MySlide({ total, page, setPage, style, setStyle}: num) {

    const numPages = Math.ceil(total / 15);

    const firstLeftClick = useRef(true);
    const firstRightClick = useRef(true);
    const slide = useRef(1);

    const leftClick = () => {
        if (firstLeftClick.current) {
            firstLeftClick.current = false;
            firstRightClick.current = true;
        } else {
            setPage(page - 1)
        }
        slide.current -= 1;
        setStyle("-translate-x-full animate-slidetoright");
    };

    const rightClick = () => {
        if (firstRightClick.current) {
            firstLeftClick.current = true;
            firstRightClick.current = false;
        } else {
            setPage(page + 1)
        }
        slide.current += 1;
        setStyle("animate-slidetoleft");
    };

    return (
        <div>
            <button onClick={leftClick} disabled={slide.current === 1}>
                &lt;{slide.current}
            </button>
            <button onClick={rightClick} disabled={slide.current === numPages}>
                &gt;
            </button>
        </div>
        

    );
};




{/* {Array(numPages)
        .fill(1)
        .map((_, i) => (
            <button key={i + 1} onClick={() => setPage(i + 1)}>
                {i + 1}
            </button>
        ))} */}