import React, { MouseEventHandler } from "react";
import { PostType } from "../types";

type Props = {
  post: PostType;
  handleClick: MouseEventHandler;
};

export default function Post({ handleClick, post }: Props) {
  return (
    <div className="flex flex-row h-16 divide-x-2 border-2 border-solid">
      <div className="basis-full">
        <button id={post.userId} onClick={handleClick}>
          {post.title}
        </button>
      </div>
      <div className="basis-3/12">{post.date}</div>
      <div className="basis-2/12">{post.counts}</div>
    </div>
  );
}
