import React, { MouseEvent } from "react";
import { useLocation, useNavigate, Link, Outlet } from "react-router-dom";
import { postApi } from "../apis";
import { PostType } from "../types";

export interface PostState {
  state: PostType;
}

export function IntoPost() {
  const location = useLocation() as PostState;
  const post = location.state;
  const navigate = useNavigate();
  // console.log(post);

  const handleDeleteClick = async (event: MouseEvent<HTMLButtonElement>) => {
    const postId = event.currentTarget.id;
    const res = await postApi.deletePost(postId);
    navigate("/board", { replace: true });
    console.log("delete post", res);
  };

  return (
    <div>
      <div>
        <div>
          <div className="flex flex-row basis-8 gap-x-1">
            <div className="border-2 border-sky-300 border-current rounded">
              <button id={post._id} onClick={handleDeleteClick}>
                delete
              </button>
            </div>
            <div className="border-2 border-sky-300 border-current rounded">
              <Link to="/edit" state={post}>
                <button>update</button>
              </Link>
            </div>
          </div>
          <div className="flex flex-row gap-x-1">
            <div className="flex basis-3/4 border-2 border-sky-300 rounded">
              제목: {post.title}
            </div>
            <div className="flex basis-1/4 border-2 border-sky-300 rounded">
              작성자: {post.user}
            </div>
          </div>
          <div className="flex flex-row gap-x-1">
            <div className="flex basis-1/4 border-2 border-sky-300 rounded">
              도시: {post.city}
            </div>
            <div className="flex basis-1/4 border-2 border-sky-300 rounded">
              테마: {post.theme}
            </div>
            <div className="flex basis-1/4 border-2 border-sky-300 rounded">
              작성일: {post.date}
            </div>
            <div className="flex basis-1/4 border-2 border-sky-300 rounded">
              조회수: {post.counts}
            </div>
          </div>
        </div>
        <div className="border-2 border-sky-300 rounded h-96">{post.text}</div>
      </div>
    </div>
  );
}
