import express from "express";
import { userCtrl, authCtrl, fileInfoCtrl } from "../controllers";

const router = express.Router();

router
  .route("/")
  .get(authCtrl.requireLogin, userCtrl.getProfile)
  .post(authCtrl.requireLogin, fileInfoCtrl.uploadFile, userCtrl.updateProfile); //중간에 req쪽에 fields와 files 넣는 미들웨어 추가

router.route("/delete").delete(authCtrl.requireLogin, userCtrl.deleteUser);

export default router;
