import React, { MouseEventHandler, useState } from "react";

type ThemeProps = {
  handleClick: MouseEventHandler;
};

export default function Theme({ handleClick }: ThemeProps) {
  const [active, setActive] = useState(0);

  const onactive = "whitespace-nowrap px-5 text-sky-300 ";
  const offactive = "whitespace-nowrap px-5 ";

  const clickActive = (a: number) => {
    setActive(a);
  };

  return (
    <div className="overflow-x-auto flex rounded py-2 md:p-2 border-b-2 divide-x-2">
      <div onClick={() => clickActive(1)}>
        <button
          id={"surfing"}
          onClick={handleClick}
          className={active === 1 ? onactive : offactive}
        >
          서핑
        </button>
      </div>
      <div onClick={() => clickActive(2)}>
        <button
          id={"activity"}
          onClick={handleClick}
          className={active === 2 ? onactive : offactive}
        >
          액티비티
        </button>
      </div>
      <div onClick={() => clickActive(3)}>
        <button
          id={"camping"}
          onClick={handleClick}
          className={active === 3 ? onactive : offactive}
        >
          캠핑
        </button>
      </div>
      <div onClick={() => clickActive(4)}>
        <button
          id={"skiing"}
          onClick={handleClick}
          className={active === 4 ? onactive : offactive}
        >
          스키
        </button>
      </div>
      <div onClick={() => clickActive(5)}>
        <button
          id={"boat"}
          onClick={handleClick}
          className={active === 5 ? onactive : offactive}
        >
          보트
        </button>
      </div>
      <div onClick={() => clickActive(6)}>
        <button
          id={"desert"}
          onClick={handleClick}
          className={active === 6 ? onactive : offactive}
        >
          사막
        </button>
      </div>
      <div onClick={() => clickActive(7)}>
        <button
          id={"golf"}
          onClick={handleClick}
          className={active === 7 ? onactive : offactive}
        >
          골프
        </button>
      </div>
      <div onClick={() => clickActive(8)}>
        <button
          id={"cave"}
          onClick={handleClick}
          className={active === 8 ? onactive : offactive}
        >
          동굴
        </button>
      </div>
      <div onClick={() => clickActive(9)}>
        <button
          id={"history"}
          onClick={handleClick}
          className={active === 9 ? onactive : offactive}
        >
          문화재
        </button>
      </div>
      <div onClick={() => clickActive(10)}>
        <button
          id={"zoo"}
          onClick={handleClick}
          className={active === 10 ? onactive : offactive}
        >
          동물원
        </button>
      </div>
      <div onClick={() => clickActive(11)}>
        <button
          id={"cycling"}
          onClick={handleClick}
          className={active === 11 ? onactive : offactive}
        >
          사이클링
        </button>
      </div>
    </div>
  );
}
