import React, { useReducer, useState } from "react";
import { Link, Outlet } from "react-router-dom";
import { useAuth } from "../auth/auth.context";

import "tailwindcss/tailwind.css";

export default function Header() {
  const { logout, user } = useAuth();
  const [search, setSearch] = useState("");

  const handleChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    const newvalue = e.target.value;
    setSearch(newvalue);
  };

  return (
    <div className="flex flex-col md:px-56 ">
      <div className="flex flex-col-reverse pt-3 pb-12 border-b-2 border-sky-200 bg-gradient-to-t from-sky-200">
        <div className="flex mt-5 justify-between pr-3">
          <button className="ml-3 shrink-0  md:text-2xl">
            <Link to="/" className="hover:text-sky-300 active:text-purple-500">
              Travel Report
            </Link>
          </button>
          <div className="flex h-12">
            <input
              className="ml-10 focus:outline-none focus:border-y-4 focus:border-l-4 focus:border-sky-500 w-3/5 md:w-4/5 border-y-4 border-l-4 border-sky-300 pl-9 rounded-l-full focus:border-0"
              onChange={handleChange}
            />
            <button className="whitespace-nowrap bg-white border-y-4  border-r-4 border-sky-500 rounded-r-full pr-4">
              검색
            </button>
          </div>
        </div>
        <div className="flex justify-end ">
          {user.isLoggedIn ? (
            <div className="flex text-xs">
              <Link to="/profile" className="mr-2 ">
                프로필
              </Link>
              <div className="border-0 border-r-2 border-black "></div>
              {user.role === "admin" ? <Link to={"/admin"}>어드민</Link> : null}
              <button
                className="ml-2 text-xs"
                onClick={() => {
                  logout();
                }}
              >
                로그아웃
              </button>
            </div>
          ) : (
            <button className="shrink-0 ">
              <Link
                className="hover:text-sky-300 focus:text-purple-500 text-xs grid items-center"
                to="/login"
              >
                로그인
              </Link>
            </button>
          )}
          <div className="ml-2 border-0 border-r-2 border-black "></div>
          <div></div>
          <button className="shrink-0 mr-3 text-xs ">
            <Link
              to="/board"
              className="hover:text-sky-300 focus:text-purple-500 mx-2 grid items-center"
            >
              게시판
            </Link>
          </button>
        </div>
      </div>

      <Outlet />
    </div>
  );
}
