import React, { useEffect, MouseEvent, useState, useRef } from "react";
import { Outlet, useSearchParams } from "react-router-dom";
import Theme from "./theme";
import Citylist from "../Pages/citylist";
import { MySlide } from "../Pages/myslide";
import { mainimgApi } from "../apis";
import { MainimgType } from "../types";

const initSearchParams = { theme: "", city: "" };

export default function Body() {
  const [searchParams, setSearchParams] = useSearchParams(initSearchParams);

  const [getimgs, setGetimgs] = useState<MainimgType[]>([]);

  async function imgsData() {
    const imgs = await mainimgApi.getmainimg();
    setGetimgs(imgs);
  }
  useEffect(() => {
    imgsData();
  }, []);

  // useEffect(() => {
  //   console.log(searchParams.get("theme"), searchParams.get("city"));
  //   setSearchParams(searchParams);
  // }, []);

  const themeHandleClick = (event: MouseEvent<HTMLButtonElement>) => {
    console.log(`theme id= ${event.currentTarget.id}`);
    setSearchParams({
      ...Object.fromEntries(searchParams),
      theme: event.currentTarget.id,
    });
    // setPage(1)
  };

  const cityHandleClick = (event: MouseEvent<HTMLButtonElement>) => {
    console.log(`city id= ${event.currentTarget.id}`);
    setSearchParams({
      ...Object.fromEntries(searchParams),
      city: event.currentTarget.id,
    });
  };

  //picture insert
  let themechange = searchParams.get("theme");
  let citylistchange = searchParams.get("city");

  const Idpics = getimgs.filter((p) => {
    return (
      (p.theme == themechange && p.city == citylistchange) ||
      (p.theme == themechange && citylistchange == "") ||
      (themechange == "" && p.city == citylistchange) ||
      (themechange == "" && citylistchange == "")
    );
  });

  let limit = 4;
  const numPages = Math.ceil(Idpics.length / limit);

  const slides = [];
  for (let i = 0; i < numPages; i++) {
    const k = [
      Idpics.slice(i * limit, i * limit + limit).map(
        (picture, index: number) => (
          <div
            className={`m-1 shrink-0 rounded shadow-md h-50 relative overflow-hidden`}
            key={index}
          >
            <img
              src={
                "http://localhost:3000/images/" + picture.fileInfo.newfilename
              }
              className="w-full h-48 object-cover hover:scale-110 transition duration-0 hover:duration-500"
            />
            <div className="bg-transparent text-neutral-50 text-xs md:text-lg rounded-full absolute bottom-0 ml-1 mb-1 hover:scale-110 transition duration-0 hover:duration-500">
              <span>{picture.title}</span>
            </div>
          </div>
        )
      ),
    ];
    slides.push(k);
  }

  return (
    <div className="flex flex-col">
      <Theme handleClick={themeHandleClick} />
      <div className="flex flex-col md:flex-row py-5 ">
        <div className="md:w-1/5 lg:w-1/6">
          <Citylist handleClick={cityHandleClick} />
        </div>
        <div className="flex flex-col">
          <MySlide key={Math.random()} slides={slides} />
        </div>
      </div>
      <Outlet />
    </div>
    // Body Page
  );
}
