import React from "react";
import { BrowserRouter, Route, Routes, Link, Outlet} from "react-router-dom";
import "tailwindcss/tailwind.css";
import Header from "./Pages/header";
import Body from "./Pages/body";
import Board from "./Pages/board";
import Login from "./Pages/login";
import Citylist from "./Pages/citylist";
import Theme from "./Pages/theme";
import Signup from "./Pages/signup";

export const App = () => {
  return (
    <BrowserRouter>
      <Routes>
        <Route path="/login" element={<Login />} />
        <Route path="/signup" element={<Signup />} />
        <Route path="/" element={<Header />}>
          <Route index element={<Body />} />
          <Route path="/board" element={<Board />} />
        </Route>
      </Routes>
    </BrowserRouter>
  );
};
