import { NextFunction, Request, Response } from "express";
import isLength from "validator/lib/isLength";
import { TypedRequestAuth } from "./auth.controller";
import { asyncWrap } from "../helpers";
import { mainimgDb } from "../db";
import { TypedRequest } from "../types";
import { ObjectId } from "mongoose";
import formidable from "formidable";

export const createMainimg = asyncWrap(async (reqExp, res) => {
  const req = reqExp as TypedRequestAuth<{ userId: ObjectId }>;
  const { userId } = req.auth;

  const form = formidable({
    uploadDir: "adminpics",
    keepExtensions: true,
    multiples: false,
  });

  form.parse(req, (err, fields, files) => {
    if (!Array.isArray(files.mainimg)) {
      //파일 좁히기 중
      if (
        !(
          Array.isArray(fields.city) ||
          Array.isArray(fields.title) ||
          Array.isArray(fields.theme)
        )
      ) {
        const city = fields.city;
        const title = fields.title;
        const theme = fields.theme;

        // if (!isLength(title ?? "", { min: 1 })) {
        //   return res.status(422).send("이미지 제목을 입력해주세요");
        // }
        console.log(files);
        const originalfilename = files.mainimg?.originalFilename;
        const newfilename = files.mainimg.newFilename;
        if (!(originalfilename === null || newfilename === undefined)) {
          mainimgDb.createMainimg(
            { city, title, theme },
            {
              originalfilename,
              newfilename,
            }
          );
        }
      }
    }
  });

  res.json();
});

export const getMainimg = asyncWrap(async (req, res) => {
  const mainimgs = await mainimgDb.getMainimg();
  return res.json(mainimgs);
});

export const deleteMainimg = asyncWrap(async (req, res) => {
  const { imgId } = req.params;
  console.log(imgId);
  const deleteCount = await mainimgDb.deleteOneMainimg(imgId);

  return res.json(deleteCount);
});
