import React, { useState, } from "react";
import { PostType } from "./typesrc";
import Post from "./post";

function range(start:number, end:number) {
    return (new Array(end - start + 1)).fill(undefined).map((_, i) => i + start);
}

const fakes = [{id: "a", title:'부산남자의 서울여행', date:'2022-06-30',},{id: "b", title:'바다!바다!바다!', date:'2022-08-01',}, {id: "c", title:'Jeju-island', date:'2022-9-10',}, {id: "d", title:'마! 부싼 가봤나!', date:'2022-9-22', }, {id: "e", title:'Daegu', date:'2022-10-1', }, {id: "f", title:'강원도 감자는 맛있다.', date:'2022-12-12',},{id: "g", title:'여행가고싶다...',date:'2022-12-25',}];

interface Posts {
    posts: PostType[];
}

export default function BoardPage() {
    
    const [posts, setPosts] = useState<PostType[]>(fakes);  

    return (
        <div className="flex flex-col items-center">
            <div className="flex flex-col items-center mt-6">
                <div>
                    `Travel Report's Board`
                </div>
                <div>
                    `여행지 후기를 남겨주세요!`
                </div>
            </div>

            <div className="flex flex-col w-10/12 mt-16">
                <div className="flex justify-end">
                    <div className="border-2 mb-2"><button>글쓰기+</button></div> {/* Link */}
                </div>
                <div className="sm:overflow-y-scroll">
                    <div className="flex flex-row divide-x-2 border-2 border-solid bg-gray-500 border-y-2 h-10 ">
                                <div className="basis-full">Title</div>
                                <div className="basis-3/12">Date</div>
                                <div className="basis-2/12">Clicks</div>
                    </div>
                    <div>
                        {posts.map((post) => (
                            <Post key={post.id} post={post}/>
                        ))}
                    </div>
                </div>
            </div>
        </div>
    );
}