import express from "express";
import { userCtrl, authCtrl, fileInfoCtrl } from "../controllers";

const router = express.Router();

router
  .route("/")
  .get(authCtrl.requireLogin, userCtrl.getUsers)
  .post(
    authCtrl.requireLogin,
    authCtrl.hasRole("admin"),
    fileInfoCtrl.uploadFile,
    userCtrl.createUser
  );

export default router;
