import axios from "axios";
import baseUrl from "../utils/baseUrl.js";

const addsubject = async (info, userId) => {
  const url = `${baseUrl}/api/subject/addsubject`;
  const { data } = await axios.post(url, { info, userId });
  return data
}

const allSubject = async (info) => {
  const url = `${baseUrl}/api/subject/all/${info}`
  const { data } = await axios.get(url);
  return data
}
const editSubject = async (info, id) => {
  const url = `${baseUrl}/api/subject/${id}`
  const { data } = await axios.put(url, info)
  return data
}

const getSubInfo = async (info) => {
  const url = `${baseUrl}/api/subject/${info}`
  const { data } = await axios.get(url);
  return data
}

const subjectTitle = async (info) => {
  const url = `${baseUrl}/api/subject/title/${info}`
  const { data } = await axios.get(url);
  return data
}


const subjectApi = {
  addsubject,
  getSubInfo,
  editSubject,
  allSubject,
  subjectTitle
};

export default subjectApi