import axios from "axios";
import baseUrl from "../utils/baseUrl";

const getDetail = async (planId) => {
  const url = `${baseUrl}/api/plan/${planId}`
  const { data } = await axios.get(url)
  return data
}

// const addPlan = async (info, id) => {
//   console.log('addPlan 확인', id)
//   const url = `${baseUrl}/api/plan/addplan/${id}`
//   const { data } = await axios.post(url, { info, id });
//   return data
// }

// const editPlan = async (info, id) => {
//   console.log('editPlan확인', id)
//   const url = `${baseUrl}/api/plan/edit/${id}`
//   const { data } = await axios.put(url, { info, id });
//   return data
// }

const submit = async (info) => {
  const url = `${baseUrl}/api/plan`
  const { data } = await axios.post(url, info)
  return data
}

const edit = async (info, planId) => {
  const url = `${baseUrl}/api/plan/${planId}`
  const { data } = await axios.put(url, info)
  return data
}

const remove = async (planId) => {
  const url = `${baseUrl}/api/plan/${planId}`
  const { data } = await axios.delete(url)
  return data
}

const planApi = {
  getDetail,
  // addPlan,
  // editPlan,
  submit,
  edit,
  remove
};

export default planApi