import { BrowserRouter as Router, Route, Switch } from "react-router-dom";
import HomePage from "./pages/HomePage";
import SchedulePage from "./pages/SchedulePage";
import ScheduleEditPage from "./pages/ScheduleEditPage";
import AdminPage from "./pages/AdminPage";
import PrivateRoute from "./components/PrivateRoute";
import Err from "./pages/ErrorPage";

function App() {
  return (
    <Router basename={process.env.PUBLIC_URL}>
      <Switch>
        <Route path="/" component={Err} />
        <Route path="/home" component={HomePage} />
        <Route path="/schedule/edit" component={ScheduleEditPage} />
        <Route path="/schedule" component={SchedulePage} />
        <PrivateRoute path="/admin" component={AdminPage} role="admin" />
      </Switch>
    </Router>
  );
}

export default App;