import { Link, Redirect } from "react-router-dom";
import { useAuth } from "../../utils/context.js";
import moment from "moment";
import styles from "./menu.module.scss";

const Menu = () => {
    const { logout } = useAuth();
    return (
        <>
            <button className="btn btn-crimson shadow-none mt-2" type="button" data-bs-toggle="collapse" data-bs-target="#menuContent" aria-controls="menuContent" aria-expanded="false" aria-label="menu">
                <i className="bi bi-list fs-4"></i>
            </button>
            <div className={`collapse collapse-horizontal position-absolute top-0 start-0 h-100 ${styles.content}`} id="menuContent">
                <div className="d-flex flex-column" style={{ transition: ".15s ease", height: "inherit" }}>
                    <button type="button" className={`btn-close btn-close-white btn-lg position-absolute ${styles.close}`} data-bs-toggle="collapse" data-bs-target="#menuContent" aria-controls="menuContent" aria-expanded="true" aria-label="menu"></button>
                    <div className="d-flex flex-column align-items-center text-white py-5" style={{ backgroundColor: "crimson" }}>
                        <h1 className="my-3">김수빈 님</h1>
                        <h2 className="my-2">오늘의 목표 95% 달성!</h2>
                    </div>
                    <div className="d-flex flex-column justify-content-between flex-grow-1 py-4 ps-3 text-dark" >
                        <div className="user-select-none w-75 ps-3">
                            <h2 className="mb-5">To-do</h2>
                            <div className="d-flex mt-2">
                                <p className={`form-check-label border-bottom border-2 fs-5 pb-1 me-3 ${styles.title}`}>sdasdsasdasdsadsadsadsadsadsadsadaddad</p>
                                <input className={`form-check-input rounded-0 border-dark shadow-none mt-1 ${styles.checkBox}`} type="checkbox" id="inlineCheckbox1" value="" aria-label="checkbox" />
                            </div>
                            <div className="d-flex">
                                <p className={`form-check-label border-bottom border-2 fs-5 pb-1 me-3 ${styles.title}`}>sdasdsadad</p>
                                <input className={`form-check-input rounded-0 border-dark shadow-none mt-1 ${styles.checkBox}`} type="checkbox" id="inlineCheckbox1" value="" aria-label="checkbox" />
                            </div>
                            <div className="d-flex">
                                <p className={`form-check-label border-bottom border-2 fs-5 pb-1 me-3 ${styles.title}`}>sdasdsadad</p>
                                <input className={`form-check-input rounded-0 border-dark shadow-none mt-1 ${styles.checkBox}`} type="checkbox" id="inlineCheckbox1" value="" aria-label="checkbox" />
                            </div>
                            <Link className="d-flex justify-content-center text-dark text-decoration-none" to={`/todo/${moment().format("YYYY-MM-DD")}`}>
                                <i className="bi bi-plus-lg me-2"></i>
                                <p className="mb-0">더보기</p>
                            </Link>
                        </div>
                        <div className="d-flex flex-column">
                            <Link className="text-dark text-decoration-none" to={`/schedule/${moment().format("YYYY-MM-DD")}`}><i className="bi bi-check"></i>일정</Link>
                            <Link className="text-dark text-decoration-none" to="/studyplan"><i className="bi bi-check"></i>학업별 계획</Link>
                        </div>
                        <p className={`position-absolute bottom-0 text-dark ${styles.logout}`} onClick={logout}>로그아웃</p>
                    </div>
                </div>
            </div>
        </>
    )
}

export default Menu