import axios from "axios";
import baseUrl from "../utils/baseUrl.js";

const getUser = async () => {
  const url = `${baseUrl}/api/auth/user`
  const { data } = await axios.get(url)
  return data
}

const signup = async (user) => {
  const url = `${baseUrl}/api/auth/signup`;
  const { data } = await axios.post(url, user);
  return data
}

const login = async (user) => {
  const url = `${baseUrl}/api/auth/login`;
  const { data } = await axios.post(url, user);
  return data
}

const logout = async () => {
  const url = `${baseUrl}/api/auth/logout`;
  const { data } = await axios.get(url);
  return data
}

const authApi = {
  getUser,
  signup,
  login,
  logout
};

export default authApi