import express from 'express';
import kuCtrl from "../controllers/ku.controller.js";
import scheduleCtrl from "../controllers/schedule.controller.js";

const router = express.Router();

router
    .route("/ku")
    .get(kuCtrl.querySeparation, kuCtrl.findbyId, kuCtrl.findbyDate, kuCtrl.send)
    .post(kuCtrl.create)
    .put(kuCtrl.edit)
    .delete(kuCtrl.remove)

router
    .route("/:userId")
    .post(scheduleCtrl.create)
    .put(scheduleCtrl.edit)
    .delete(scheduleCtrl.remove)

export default router;