import bcrypt from "bcryptjs";
import Sequelize from "sequelize";

const { DataTypes } = Sequelize;

const UserModel = (sequelize) => {
  const User = sequelize.define(
    "user",
    {
      userID: {
        type: DataTypes.STRING
      },
      userName: {
        type: DataTypes.STRING
      },
      password: {
        type: DataTypes.STRING
      },
      studNum: {
        type: DataTypes.STRING
      }
    }
  );

  User.beforeSave(async (user) => {
    // if (!user.changed("password")) {
    //   return;
    // }
    if (user.password) {
      const hashedPassword = await bcrypt.hash(user.password, 10);
      user.password = hashedPassword;
    }
  });
  return User
};


export default UserModel;