import { BrowserRouter as Router, Route, Switch } from "react-router-dom";
import LoginPage from "./pages/LoginPage";
import SignupPage from "./pages/SignupPage";
import HomePage from "./pages/HomePage";
import SchedulePage from "./pages/SchedulePage";
import ScheduleEditPage from "./pages/ScheduleEditPage";
import AdminPage from "./pages/AdminPage";
import PrivateRoute from "./components/PrivateRoute";
import ErrorPage from "./pages/ErrorPage";

function App() {
  return (
    <Router basename={process.env.PUBLIC_URL}>
      <div id="box" className="container position-relative vh-100 mx-sm-auto">
        <Switch>
          <Route exact path="/" component={LoginPage} />
          <Route path="/login" component={LoginPage} />
          <Route path="/signup" component={SignupPage} />
          <Route path="/home" component={HomePage} />
          <Route path="/schedule/edit" component={ScheduleEditPage} />
          <Route path="/schedule" component={SchedulePage} />
          <PrivateRoute path="/admin" component={AdminPage} role="admin" />

          <Route component={ErrorPage} />
        </Switch>
      </div>
    </Router>
  );
}

export default App;